/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public final class VBOTest {
    private static boolean finished;
    private static float angle;
    private static int buffer_id;
    private static FloatBuffer vertices;
    private static ByteBuffer mapped_buffer;
    private static FloatBuffer mapped_float_buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        try {
            VBOTest.init();
            while (!finished) {
                Display.update();
                if (!Display.isVisible()) {
                    Thread.sleep(200L);
                } else if (Display.isCloseRequested()) {
                    System.exit(0);
                }
                VBOTest.mainLoop();
                VBOTest.render();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            VBOTest.cleanup();
        }
        System.exit(0);
    }

    private static void mainLoop() {
        int i;
        if ((angle += 1.0f) > 360.0f) {
            angle = 0.0f;
        }
        if (Mouse.getDX() != 0 || Mouse.getDY() != 0 || Mouse.getDWheel() != 0) {
            System.out.println("Mouse moved " + Mouse.getDX() + " " + Mouse.getDY() + " " + Mouse.getDWheel());
        }
        for (i = 0; i < Mouse.getButtonCount(); ++i) {
            if (!Mouse.isButtonDown((int)i)) continue;
            System.out.println("Button " + i + " down");
        }
        if (Keyboard.isKeyDown((int)1)) {
            finished = true;
        }
        for (i = 0; i < Keyboard.getNumKeyboardEvents(); ++i) {
            Keyboard.next();
            if (Keyboard.getEventKey() == 1 && Keyboard.getEventKeyState()) {
                finished = true;
            }
            if (Keyboard.getEventKey() != 20 || !Keyboard.getEventKeyState()) continue;
            System.out.println("Current time: " + Sys.getTime());
        }
    }

    private static void render() {
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(Display.getDisplayMode().getWidth() / 2), (float)(Display.getDisplayMode().getHeight() / 2), (float)0.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        ByteBuffer new_mapped_buffer = ARBVertexBufferObject.glMapBufferARB((int)34962, (int)35001, (ByteBuffer)mapped_buffer);
        if (new_mapped_buffer != mapped_buffer) {
            mapped_float_buffer = new_mapped_buffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        mapped_buffer = new_mapped_buffer;
        mapped_float_buffer.rewind();
        vertices.rewind();
        mapped_float_buffer.put(vertices);
        if (ARBVertexBufferObject.glUnmapBufferARB((int)34962)) {
            GL11.glDrawArrays((int)7, (int)0, (int)4);
        }
        GL11.glPopMatrix();
    }

    private static void init() throws Exception {
        System.out.println("Timer resolution: " + Sys.getTimerResolution());
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)Display.getDisplayMode().getWidth(), (float)0.0f, (float)Display.getDisplayMode().getHeight());
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)Display.getDisplayMode().getWidth(), (int)Display.getDisplayMode().getHeight());
        if (!GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            System.out.println("ARB VBO not supported!");
            System.exit(1);
        }
        buffer_id = ARBVertexBufferObject.glGenBuffersARB();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)buffer_id);
        vertices = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        vertices.put(-50.0f).put(-50.0f).put(50.0f).put(-50.0f).put(50.0f).put(50.0f).put(-50.0f).put(50.0f);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (long)32L, (int)35040);
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)2, (int)5126, (int)0, (long)0L);
    }

    private static void cleanup() {
        ARBVertexBufferObject.glDeleteBuffersARB((int)buffer_id);
        Display.destroy();
    }

    static {
        try {
            int mode = -1;
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != 640 || modes[i].getHeight() != 480 || modes[i].getBitsPerPixel() < 16) continue;
                mode = i;
                break;
            }
            if (mode != -1) {
                System.out.println("Setting display mode to " + modes[mode]);
                Display.setDisplayMode((DisplayMode)modes[mode]);
                System.out.println("Created display.");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create display due to " + e);
        }
        try {
            Display.create();
            System.out.println("Created OpenGL.");
        }
        catch (Exception e) {
            System.err.println("Failed to create OpenGL due to " + e);
            System.exit(1);
        }
    }
}

